<?php
/****
 * vB Optimise
 * Copyright 2008; Deceptor
 * All Rights Reserved
 * Code may not be copied, in whole or part without written permission
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 */

if (!is_object($vbulletin))
{
	die('Cannot access directly.');
}

require_once(DIR . '/includes/class_activecache_methods.php');

class vb_activecache_vBAdvanced extends vb_activecache
{
	static $class = __CLASS__;
	static $instance;
	static $settings;
	var $hooks = array(
		'vba_cmps_admin_add_edit_module_end',
		'vba_cmps_admin_do_add_edit_module',
		'vba_cmps_fetch_vba_module',
	);

	function get_instance($method = '')
	{
		return (self::$instance) ? self::$instance : (self::$instance =& new self::$class());
	}

	function __construct()
	{
		global $vbulletin;

		$hookobj =& vBulletinHook::init();

		foreach ($this->hooks as $hook)
		{
			$hookcode = 'hook_' . $hook;
			$hookobj->pluginlist[$hook] .= "\r\n" . trim($this->$hookcode());
		}

		unset($hookobj);
	}

	function suicide()
	{
		if (self::$instance)
		{
			self::$instance = null;
		}
	}

	function fetch_setting($moduleid, $setting)
	{
		return self::$settings[$moduleid][$setting];
	}

	function save_setting($moduleid, $cache, $time)
	{
		require_once(DIR . '/includes/adminfunctions_options.php');

		self::compile_settings();

		self::$settings[$moduleid] = array(
			'cache'	=> $cache,
			'time'	=> $time,
		);

		self::$settings = serialize(self::$settings);

		save_settings(array(
			'_vboptimise_vba_cmps' => self::$settings,
		));
	}

	function compile_settings()
	{
		global $vbulletin;

		if (empty(self::$settings) || is_array(self::$settings))
		{
			self::$settings = unserialize($vbulletin->options['_vboptimise_vba_cmps']);

			if (!is_array(self::$settings))
			{
				self::$settings = array();
			}
		}
	}

	function hook_vba_cmps_fetch_vba_module()
	{
return <<<vBOptimise
require_once(DIR . '/includes/class_activecache.php');

vb_activecache_vBAdvanced::compile_settings();

\$cache = vb_activecache_vBAdvanced::fetch_setting(\$mods['modid'], 'cache');
\$time = vb_activecache_vBAdvanced::fetch_setting(\$mods['modid'], 'time');

if (\$cache && \$time > 0)
{
	\$activecache = vb_activecache::get_instance(\$vbulletin->options['_vboptimise_method']);
	\$module_cache = \$activecache->fetch('vba_module_' . \$mods['modid']);

	if (\$module_cache == false && !\$module_cache = \$activecache->fetch('vba_module_' . \$mods['modid']))
	{
		\$set_cache = true;
	}
	else
	{
		\$module_cache = unserialize(\$module_cache);

		if ((\$module_cache['time'] + \$time) < TIMENOW)
		{
			\$set_cache = true;
		}
		else
		{
			devdebug('vB Optimise: Fetched vBAdvanced Module from cache, ID: ' . \$mods['modid']);

			if (\$vbulletin->debug AND \$_REQUEST['explain'])
			{
				echo '<div class="explainbody"><strong>vB Optimise:</strong> Returned module from cache.</div>';
			}

			\$home[\$mods['modid']]['content'] = str_replace('{BGCLASS}', \$bgclass, \$module_cache['module']);

			\$mods = \$module_cache['mods'];

			\$mods['filename'] = '../includes/module_blank.txt';

			return false;
		}
	}

	if (\$set_cache)
	{
		devdebug('vB Optimise: Fetching vBAdvanced Module output to cache, ID: ' . \$mods['modid']);

		\$oldbgclass = \$bgclass;
		\$bgclass = '{BGCLASS}';

		if (\$mods['options'] & \$vba_php_modint['clean_output'])
		{
			devdebug('vB Optimise: Cannot cache vBAdvanced Module (ID: ' . \$mods['modid'] . ') due to clean output setting.');

			return false;
		}
		else
		{
			require(DIR . '/modules/' . \$mods['filename']);
		}

		// Some vBAdvanced modules modify the $mods variable on-the-fly, to compete with this we will cache the changed variables and deploy them when fetching from cache to avoid issues

		\$cache = array(
			'module'	=> \$home[\$mods['modid']]['content'],
			'time'		=> TIMENOW,
			'mods'		=> \$mods,
		);

		\$activecache->set('vba_module_' . \$mods['modid'], serialize(\$cache));

		\$mods['filename'] = '../includes/module_blank.txt';

		\$bgclass = \$oldbgclass;

		\$home[\$mods['modid']]['content'] = str_replace('{BGCLASS}', \$bgclass, \$home[\$mods['modid']]['content']);

		devdebug('vB Optimise: Cached vBAdvanced Module ID: ' . \$mods['modid']);
	}
}

vBOptimise;
	}

	function hook_vba_cmps_admin_do_add_edit_module()
	{
return <<<vBOptimise
require_once(DIR . '/includes/class_activecache.php');

\$cache = intval(\$_POST['vboptimise']['cache']);
\$time = intval(\$_POST['vboptimise']['time']);

vb_activecache_vBAdvanced::save_setting(\$modid, \$cache, \$time);
vBOptimise;
	}

	function hook_vba_cmps_admin_add_edit_module_end()
	{
return <<<vBOptimise
require_once(DIR . '/includes/class_activecache.php');

vb_activecache_vBAdvanced::compile_settings();

print_table_header('vB Optimise: vBAdvanced Integration');

print_description_row('Cache vBAdvanced Module: ' . \$module['title'], 0, 2, 'optiontitle');

print_yes_no_row('<div class="smallfont">
vB Optimise can cache this vBAdvanced module for you, please be aware we do not recommend doing so if this module displays informtion for the user who is logged, like the Welcome Block module.
<br /><br />
If you wish to cache this module, set this option to Yes, then below enter how many seconds you want the cache to remain, a safe setting would be 60 seconds.
</div>', 'vboptimise[cache]', vb_activecache_vBAdvanced::fetch_setting(\$modid, 'cache'));

print_input_row('<div class="smallfont">
If you have selected Yes above, you will need to enter a time here in seconds which will tell vB Optimise how long it should keep the module cached for before the data is updated.
<br /><br />
A safe setting would be 60 seconds.
</div>', 'vboptimise[time]', intval(vb_activecache_vBAdvanced::fetch_setting(\$modid, 'time')));

print_table_break();
vBOptimise;
	}
}
?>